

import { UserEditWidget } from './UserEditWidget.js'; 




export class UserListWidget {

	ezTpl = null;
	
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<span ez-if="popupMode == false">
					<a href="{{appUrl('/masterdata/')}}" class="fa fa-chevron-circle-left"></a>
					<a href="{{appUrl('/masterdata/users/edit/')}}" class="fa fa-plus"></a>
				</span>
				<span ez-if="popupMode == true">
					<a [onclick]="widget.addUser_Click" class="fa fa-plus"></a>
					<a onclick="close_popup();" class="fa fa-times-circle"></a>
				</span>
			</div>
			<h1>Gebruikers</h1>
		</div>
		
		<div ez-if="users == null">
			Loading...
		</div>
		<div ez-if="users != null">
			<table class="table">
				<thead>
					<tr>
						<th>Gebruikersnaam</th>
						<th>Volledige naam</th>
						<th>E-mail</th>
						<th>Actief</th>
					</tr>
				</thead>
				<tbody ez-for="users" ez-item="u">
					<tr [onclick]="widget.editUser_Click" class="pointer">
						<td class="td-user" user-id="{{u.userId}}" [user]="u">
							{{u.username}}
						</td>
						<td>
							{{u.firstname != null ? u.firstname : ''}}
							{{u.lastname != null ? u.lastname : ''}}
						</td>
						<td>{{u.email != null ? u.email : ''}}</td>
						<td>{{u.activated ? 'Ja' : 'Nee'}}</td>
					</tr>
				</tbody>
			</table>
		</div>
	`;
	
	popupMode = false;
	
	callbackUserSelected = null;
	
	setCallbackUserSelected(callback) {
		this.callbackUserSelected = callback;
	}
	
	editUser_Click(evt, tr) {
		let user = tr.querySelector('.td-user').user;
		
		if (this.popupMode == true) {
			this.callbackUserSelected( user );
			close_popup();
		}
		else {
			gotoRoute( '/masterdata/users/edit/?id='+user.userId );
		}
	}
	
	
	
	addUser_Click( evt, obj ) {
		// this can only be clicked in popupMode==true...
		
		let uew = new UserEditWidget();
		uew.showPopup();
		
		uew.setCallbackUserCreated( (user) => {
			this.callbackUserSelected( user );
			
			close_popup();
		});
	}
	
	
	
	
	loadUsers() {
		postUrl( '/service/users.do' ).then( async function(e) {
			let json = await e.json();
			if (json.error) {
				showErrorWidget( json );
			}
			

			this.ezTpl.setObject('widget', this);
			
			this.ezTpl.setVar('users', json.objects);
			
			this.ezTpl.render();
		}.bind(this) );
	}
	
	
	
	init(e) {
		this.ezTpl = new EzTemplate( e );
		this.ezTpl.setVar('users', null);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.setVar('popupMode', this.popupMode);
		this.ezTpl.render();
		
		
		this.loadUsers();
	}
	
	
	showPopup() {
		let d = show_popup('Select user', '');
		
		this.popupMode = true;
		
		this.init(d);
	}
	
}

